/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.schematics;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.util.CustomNPCsScheduler;

public class SchematicBlockData {
    public BlockPos pos;
    public IBlockState state;
    public NBTTagCompound nbtTile;
    public World world;
    public int meta = 0;
    public int id = 0;

    public SchematicBlockData(World world, IBlockState state, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.state = state;
        this.meta = this.state.func_177230_c().func_176201_c(state);
        this.nbtTile = null;
        if (state.func_177230_c() instanceof ITileEntityProvider && world != null && world.func_175625_s(pos) != null) {
            this.nbtTile = new NBTTagCompound();
            Objects.requireNonNull(world.func_175625_s(pos)).func_189515_b(this.nbtTile);
        }
    }

    public SchematicBlockData(World world, ItemStack stack) {
        this.world = world;
        this.pos = null;
        Block b = Block.func_149634_a((Item)stack.func_77973_b());
        this.state = b.func_176223_P();
        if (stack.func_77952_i() < b.func_176194_O().func_177619_a().size()) {
            this.state = b.func_176203_a(stack.func_77952_i());
        }
        this.nbtTile = null;
        if (stack.func_77942_o()) {
            assert (stack.func_77978_p() != null);
            this.nbtTile = stack.func_77978_p().func_74737_b();
        }
    }

    public void set(BlockPos pos) {
        if (this.world == null || pos == null || this.state == null) {
            return;
        }
        this.world.func_175656_a(pos, this.state);
        if (this.nbtTile != null) {
            this.nbtTile.func_74768_a("x", pos.func_177958_n());
            this.nbtTile.func_74768_a("y", pos.func_177956_o());
            this.nbtTile.func_74768_a("z", pos.func_177952_p());
            CustomNPCsScheduler.runTack(() -> {
                TileEntity tile = this.world.func_175625_s(this.pos);
                if (tile == null) {
                    tile = this.state.func_177230_c().createTileEntity(this.world, this.state);
                }
                assert (tile != null);
                tile.func_145839_a(this.nbtTile);
                this.nbtTile.func_74768_a("x", this.pos.func_177958_n());
                this.nbtTile.func_74768_a("y", this.pos.func_177956_o());
                this.nbtTile.func_74768_a("z", this.pos.func_177952_p());
            }, 200);
        }
    }

    public void setMeta(int meta) {
        this.meta = meta;
        if (meta < this.state.func_177230_c().func_176194_O().func_177619_a().size()) {
            this.state = (IBlockState)this.state.func_177230_c().func_176194_O().func_177619_a().get(meta);
        }
    }

    public String toString() {
        return "SchematicBlockData [ ID:" + this.id + "; state:" + this.state + ",; pos:" + this.pos + "; meta:" + this.meta + "; hasNbt:" + (this.nbtTile != null) + " ]";
    }
}

